#!/usr/bin/env python
"""
Automatyzowanie domu: sprawdzanie temperatury
Projekt na Raspberry Pi
"""
import subprocess 
import time

def fileexists(filename):
        try:
                with open(filename): pass
        except IOError:
                return False
        return True

def GetTemperature():
        # Ustaw tę zmienną na True, jeśli interesuje Cię temperatura w stopniach Fahrenheita 
        Fahrenheit = False
        
		# Te dwa wiersze wywołują aplikację modprobe, aby pobrać
		# temperaturę z czujnika
        subprocess.call(['modprobe', 'w1-gpio'])
        subprocess.call(['modprobe', 'w1-therm'])
        
        # Otwórz wyświetlany wcześniej plik, aby Python mógł
        # sprawdzić jego zawartość. Zastąp podany numer własnym
        filename = "/sys/bus/w1/devices/28-0000040be5b6/w1_slave"
        if (fileexists(filename)):
                tfile = open(filename)
        else:
                return 0
        # Wczytywanie pliku w1_slave do pamięci
        text = tfile.read()
        # Zamykanie pliku
        tfile.close()
		# Potrzebny jest drugi wiersz, dlatego kod zapisuje go w zmiennej secondline
        secondline = text.split("\n")[1]
        # Potrzebne jest dziesiąte słowo drugiego wiersza
        temperaturedata = secondline.split(" ")[9]
		# Potrzebna jest liczba zapisana w dziesiątym słowie. Dlatego
		# należy odrzucić dwa pierwsze znaki (t=) i przekształcić pozostałą wartość
        temperature = float(temperaturedata[2:])
        # Podziel wartość przez 1000, aby przecinek znalazł się we właściwym miejscu
        temperature = temperature / 1000
        temp = float(temperature)
        # W razie potrzeby wartość jest przekształcana na stopnie Farenheita
        if Fahrenheit:
                temp=temp*1.8+32
        temp = round(temp,2)
        return(temp)

def main():
        # To główna procedura programu
        print "Temperatura wynosi " + str(GetTemperature())

if __name__ == "__main__":
        main()

